<?php
// backend/config.php

/**
 * Logika Deteksi Lingkungan Otomatis
 *
 * Cara ini secara otomatis menentukan apakah skrip dijalankan di lingkungan
 * lokal (development) atau di server produksi (hosting) berdasarkan nama host.
 */

// 1. Definisikan daftar nama host yang Anda gunakan untuk pengembangan lokal.
//    Kita tambahkan beberapa kemungkinan umum yang digunakan oleh Laragon, XAMPP, dll.
$local_hostnames = [
    'localhost',
    '127.0.0.1',
    'pinpri.test',
    'auth.test', // Nama host default yang sering dibuat Laragon
    // -> Tambahkan nama domain lokal lain di sini jika Anda menggunakan yang berbeda
];

// 2. Dapatkan nama server. Kita gunakan null coalescing operator (??) untuk keamanan.
$server_name = $_SERVER['SERVER_NAME'] ?? '';

// 3. Periksa apakah nama server saat ini ada di dalam daftar lokal.
if (in_array($server_name, $local_hostnames)) {
    // Jika YA, kita berada di lingkungan LOKAL.
    require_once __DIR__ . '/config-localhost.php';
} else {
    // Jika TIDAK, kita asumsikan berada di lingkungan HOSTING/PRODUKSI.
    require_once __DIR__ . '/config-hosting.php';
}


// Baris di bawah ini tetap sama dan tidak perlu diubah.
define('UPLOAD_DIR', '../uploads/');
if (!is_dir(UPLOAD_DIR)) {
    // Memberikan izin yang lebih aman (0755) daripada 0777
    mkdir(UPLOAD_DIR, 0755, true);
}
?>