<?php
// /auth/login.php
require_once __DIR__ . '/config.php'; // Muat konfigurasi untuk mendapatkan URL

// Ambil URL tujuan dari parameter GET, bersihkan untuk keamanan.
// Default redirect sekarang menggunakan konstanta dari file konfigurasi.
$redirect_url = isset($_GET['redirect_url']) ? htmlspecialchars($_GET['redirect_url']) : PINPRI_URL . '/index.php'; 
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Terpusat - Layanan ArmanJr</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { display: flex; align-items: center; justify-content: center; min-height: 100vh; background-color: #f8f9fa; }
        .login-card { max-width: 400px; width: 100%; }
    </style>
</head>
<body>
    <div class="card login-card shadow-sm">
        <div class="card-body p-4">
            <h2 class="text-center mb-4">Login Layanan</h2>
            <?php if (isset($_GET['error'])): ?>
                <div class="alert alert-danger"><?php echo htmlspecialchars($_GET['error']); ?></div>
            <?php endif; ?>
            
            <form action="auth_handler.php" method="POST">
                <input type="hidden" name="redirect_url" value="<?php echo $redirect_url; ?>">

                <div class="mb-3">
                    <label for="username" class="form-label">Username</label>
                    <input type="text" class="form-control" id="username" name="username" required>
                </div>
                
                <div class="mb-3">
                    <label for="password" class="form-label">Password</label>
                    <input type="password" class="form-control" id="password" name="password" required>
                </div>
                
                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">Login</button>
                </div>
            </form>
        </div>
    </div>
</body>
</html>