<?php
// /auth/verify_token.php - VERSI FINAL DENGAN KONEKSI DB

date_default_timezone_set('Asia/Jakarta');
header('Content-Type: application/json');

// Muat kredensial database
require 'config.php';

// --- PERBAIKAN: BUAT KONEKSI DATABASE DI SINI ---
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    // Jangan tampilkan error detail, catat di log server
    error_log("Auth Verify DB Connection Failed: " . $conn->connect_error);
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Kesalahan Internal Server']);
    exit();
}
$conn->set_charset("utf8mb4");
// --- AKHIR PERBAIKAN ---

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Metode tidak diizinkan']);
    exit();
}

$token = $_POST['token'] ?? '';

if (empty($token)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Token tidak ada']);
    exit();
}

$stmt = $conn->prepare("SELECT user_id, expires_at FROM auth_tokens WHERE token = ?");
$stmt->bind_param("s", $token);
$stmt->execute();
$result = $stmt->get_result();

if ($auth_token = $result->fetch_assoc()) {
    $delete_stmt = $conn->prepare("DELETE FROM auth_tokens WHERE token = ?");
    $delete_stmt->bind_param("s", $token);
    $delete_stmt->execute();
    $delete_stmt->close();

    $now = new DateTime();
    $expires_at = new DateTime($auth_token['expires_at']);

    if ($now > $expires_at) {
        http_response_code(401);
        echo json_encode(['success' => false, 'message' => 'Token kedaluwarsa']);
        exit();
    }

    $user_stmt = $conn->prepare("SELECT id, username, role FROM users WHERE id = ?");
    $user_stmt->bind_param("s", $auth_token['user_id']);
    $user_stmt->execute();
    $user_data = $user_stmt->get_result()->fetch_assoc();
    $user_stmt->close();

    echo json_encode(['success' => true, 'user' => $user_data]);

} else {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Token tidak valid']);
}

$stmt->close();
$conn->close();
?>